/*

This code generates the table of descriptive statistics that we have in the paper 
appendix for all the variables used in the paper. We exclude variables used in the Turkey 
plots on fiscal and monetary policy & inflation and exchange rate. We also exclude 
UIP, IAPOC and FX debt data for confidentiality issues.

*/
clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
set graphics on
//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  

use "LP_data", clear
/*******************************************************************************
Check units
*******************************************************************************/
replace i_treasury_12m_avg_US=i_treasury_12m_avg_US/100
replace i_policy_final=i_policy_final/100


/*******************************************************************************
Drop hard pegs
*******************************************************************************/
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Variables for SS table and descriptive stats table
*******************************************************************************/
//Investment growth (yoy)
g aux=FXI_reserves*nGDPnsa_USD 
g g_inv=100*(ln(rInv)-ln(l4.rInv)) // y to y

//Trade balance to GDP (change)
g g_tb=100*(trade_balance_GDP-l.trade_balance_GDP) //change in trade balance 

/*******************************************************************************
Global factors 
*******************************************************************************/
//Global dollar shock as in 0Z (2022): 10% size shock 
xtset IFS_code time_q 
g Dollar_shock=ln(aeusd_g)-ln(l.aeusd_g)
replace Dollar_shock=Dollar_shock/0.1 

//Trade balance:
bys time_q EM: egen median_tb=median(trade_balance_GDP)

//Commodity index 
g l_oil=ln(oil_index)
/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"


//generate variables used in the paper
xtset IFS_code time_q 

***depvars:
g lcpi=ln(cpi_IFS)
g ler=ln(ER_avg_IFS) 
g g_er=D.ler //ER q to q
g lgdp=ln(rGDPsa_weo)

replace DL_GDP=DL_GDP/100 


drop if time_q>tq(2019q4)
drop if time_q<tq(1990q1)

//generate table
cd "../../Figures/Tables"

// Sum stats table
estpost tabstat lgdp lcpi ln_theta_12m_treasury g_er all_DB_inflow_AHKS_GDP_2023 i_treasury_12m_avg_US ff4 mps Dollar_shock median_tb l_oil iapoc FX_debt_f DL_GDP FXI_reserves g_inv g_tb, s(mean sd min max) columns(statistics) 
esttab . using "SStats_KeyVars.tex", ///
cells("mean(fmt(3)) sd(fmt(3)) min(fmt(3)) max(fmt(3)) ") ///
nomtitle noobs nonumber replace ///
varlabels(lgdp "ln(GDP)" lcpi "ln(CPI)" ln_theta_12m_treasury "12m UIP deviation" ///
g_er "Exchange rate (\% change, q/q)" all_DB_inflow_AHKS_GDP_2023 "Capital inflows to GDP" ///
i_treasury_12m_avg_US "12m US treasury rate" ff4 "GK(15) shock" mps "BS(23) surprise" ///
Dollar_shock "Dollar shock" median_tb "Median trade balance" l_oil "ln(oil price index)" ///
iapoc "IAPOC index" FX_debt_f "FX debt to total credit to the NFS" DL_GDP "Total external debt to GDP (Bénétrix et al, 2019)" FXI_reserves "FX reserves to GDP" ///
g_inv "Investment growth (yoy)" g_tb "Trade balance/GDP change")





